
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Feb 07 09:42:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_sep.c#1:csrc:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/************* Include Files **************************************/
#include "CRYS.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"
#include "MW_ATP_UTIL_sep.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Time.h"
/* extern exit decleration from <stdlib.h> */
extern void exit(int status);


#ifdef DX_CC5_SEP_PLAT
#ifdef DX_ARM_INTEGRATOR_DEBUG
#include "CRYS_INIT_TST.h"
#endif
#include "Init_CC.h"
#include "cc_start_addr.h"

/* cache address */
DxUint32_t  TST_CacheAddr;
	
/* resident address */
DxUint32_t  TST_ResAddr;

/* resident address */
DxUint32_t  TST_ExtCacheAddr;

#endif

/************************ Defines **********************************/
#ifdef DX_ARM_INTEGRATOR_DEBUG
extern void  CRYS_TST_Init(void);
#endif
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
/*************** Private function prototype ************************/

/************************ Public Functions *************************/
/********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_Init_CRYS
 *
 * Inputs:
 *  None.
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the initialization of the CryptoCell and CRYS.
 *
 ********************************************************************************/
DxError_t MW_ATP_UTIL_Init_CRYS( void )
{
    /* Initialize Board clocks */
    #ifdef DX_ARM_INTEGRATOR_DEBUG
    CRYS_TST_Init();
    #endif
    
	/* Init the CRYS for work */
	/**********/
	#ifndef DX_CC5_SEP_PLAT
	
        #ifdef DX_CRYS_MULTI_CPU_SUPPORT
        /*Initialize Specific CryproCell */
	    TST_ATP_Error = CRYS_Init(CRYS_COMMON_TST_CRYPT_LITE_BOARD_BASE_ADDR,
                                  (DxUint8_t *)NULL,
                                  CRYS_MULTI_CPU_CP_ID);
        #else
        /* Initialize the CryptoCell */
	    TST_ATP_Error = CRYS_Init(CRYS_COMMON_TST_CRYPT_LITE_BOARD_BASE_ADDR,
                                  (DxUint8_t *)"DiscretixQA" , sizeof("DiscretixQA") );
        #endif
        
        TST_ATP_Error = TST_ATP_CheckErrorReturn(TST_ATP_Error,
                                                 "CRYS_Init",
                                                 "!!!!!!!!!",
                                                 "!!!!!!!!!");
        if (TST_ATP_Error != TST_PASS)
            return TST_FAIL;
        
	#else /*DX_CC5_SEP_PLAT*/
    
        TST_ATP_Error = MW_ATP_UTIL_Init_SEP();
        if (TST_ATP_Error != TST_PASS)
            return TST_FAIL;
	#endif
	
    return TST_PASS;
}

/********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_Init_SEP
 *
 * Inputs:
 *  None.
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the initialization of the SEP and CryptoCell.
 *
 ********************************************************************************/
DxError_t MW_ATP_UTIL_Init_SEP( void )
{
#ifdef DX_CC5_SEP_PLAT
	
	
	
	/* Load Resident code and cache */
#ifndef DX_TST_OS	
#ifndef DSM_SIM
    TST_ATP_Error = MW_ATP_UTIL_CC_LoadCode(DX_CC_HOST_RESIDENT_BASE_ADDR,DX_CC_HOST_CACHE_BASE_ADDR);
    if(TST_ATP_Error != DX_SUCCESS)
    {
        return TST_FAIL;
    }
#endif    
    TST_CacheAddr = DX_CC_HOST_CACHE_BASE_ADDR;
    TST_ResAddr = DX_CC_HOST_RESIDENT_BASE_ADDR;
    
    #ifndef DX_NO_ExtAPP_SUPPORT
#ifndef DSM_SIM
        TST_ATP_Error = MW_ATP_UTIL_CC_LoadExtCode(DX_CC_EXTAPP_MEMORY_BASE_ADDR);
        if(TST_ATP_Error != DX_SUCCESS)
        {
            return TST_FAIL;
        }
#endif
        TST_ExtCacheAddr = DX_CC_EXTAPP_MEMORY_BASE_ADDR;
    #else
        TST_ExtCacheAddr = 0x0;    
    #endif
    
#else

    TST_ATP_Error = MW_ATP_UTIL_CC_OSLoadCode(&TST_ResAddr , &TST_CacheAddr);
    if(TST_ATP_Error != DX_SUCCESS)
    {
        return TST_FAIL;
    }
    
    TST_ATP_Error = MW_ATP_UTIL_CC_OSLoadExtCode(&TST_ExtCacheAddr);
    if(TST_ATP_Error != DX_SUCCESS)
    {
        return TST_FAIL;
    }

#endif
    
    /* Start the CryptoCell*/
    TST_ATP_Error = DX_CC_Start();
    if(TST_ATP_Error != DX_SUCCESS)
    {
        return TST_FAIL;
    }
    
    /* Initialize the CryproCell */
    TST_ATP_Error = MW_TST_DX_CC_INIT();
                      		     
    if(TST_ATP_Error != DX_SUCCESS)
    {
        return TST_FAIL;
    }

    #ifndef DX_NO_ExtAPP_SUPPORT
        /* Initialize External Application */
        TST_ATP_Error = DX_CC_InitExt(TST_ExtCacheAddr, 
       								  DX_CC_INIT_OEM_KEY_TYPE);
        if(TST_ATP_Error != DX_SUCCESS)
        {
            return TST_FAIL;
        }
    #endif
#endif
    return TST_PASS;
}
/********************************************************************************
 * Function Name:
 *  TST_CheckErrorReturn
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ********************************************************************************/
CRYSError_t TST_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
                                     char         TST_FuncName[TST_FUNC_STRING_LEN],
                                     char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                     char         TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet != CRYS_OK)
        {
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - SubTest Name - %s \n",TST_SubTestName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - return code 0x%x \n",TST_ErrorRet));
            return TST_FAIL;
        }
    else
        {
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n TST_message - "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"%s",TST_FuncName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG," pass \n"));
            return TST_PASS;
        }
}


/**/
#ifndef DSM_SIM
DxError_t MW_TST_Util_GetTime(DxUint32_t* TST_timeValue)
{
#if defined(DX_ARM_INTEGRATOR_DEBUG) | DX_TST_OS 
  DxUint32_t    timeVal;
  
  timeVal = time(DX_NULL);
  
  *TST_timeValue = timeVal;

#else
  *TST_timeValue = DX_VOS_GetTime();
#endif
  
  return DX_SUCCESS;
  
}
#endif

/************************ Private Functions *************************/

